﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace VIRP_WEB.BaseCode
{
    [Serializable()]
    public class ViaServiceData
    {
        private string siteCode;
        private string dUZ;
        private string dFN;
        private string serverIP;
        private string serverPort;
        private string userName;
        private string patientName;
        private string patientDOB;
        private string patientDOD; // Deceased Date
        private string patientGender;
        private string patientSnum;
        private string patientLocationId;
        private string patientICN;
        private string patientDFN;
        private string sTA6N;
        private string patientAdmitTimeStamp;
        private string institutionName;

        // Demographics
        private string patientAge;
        private string patientCity;
        private string patientState;
        private string patientMaritalStatus;
        private string patientReligion;
        private int patientRegion;
        private string patientRace;
        private string patientEthnicity;
        private int cprsSentTBIEvaluationNoteId;
        private int cprsSentTBIFollowUpNoteId;
        private NoteType selectedNoteType;
        private string noteText;
        private string selectedNoteTitleId;
        private string selectedConsultId;
        private string selectedVisitId;
        private string selectedHospitalAdmissionId;
        private string selectedLocationID;
        private string selectedNewVisitId;
        private string selectedCosignerID;
        private bool isHistorical;
        private string stationNumber;
        private string providerDFN;
        private ViaServices.ViaPerson vIAServiceCprsLaunch;
        private string loginSiteCode;
        private string tokenizedDUZ;
        private string providerName;

        public ViaServiceData()
        {
            this.Refresh();
        }

        #region Properties

        public string SiteCode
        {
            get
            {
                return this.siteCode;
            }
            set
            {
                this.siteCode = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string DUZ
        {
            get
            {
                return this.dUZ;
            }
            set
            {
                this.dUZ = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string DFN
        {
            get
            {
                return this.dFN;
            }
            set
            {
                this.dFN = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string ServerIP
        {
            get
            {
                return this.serverIP;
            }
            set
            {
                this.serverIP = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string ServerPort
        {
            get
            {
                return this.serverPort;
            }
            set
            {
                this.serverPort = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string UserName
        {
            get
            {
                return this.userName;
            }
            set
            {
                this.userName = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientName
        {
            get
            {
                return this.patientName;
            }
            set
            {
                this.patientName = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientDOB
        {
            get
            {
                return this.patientDOB;
            }
            set
            {
                this.patientDOB = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        // Deceased Date
        public string PatientDOD
        {
            get
            {
                return this.patientDOD;
            }
            set
            {
                this.patientDOD = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientGender
        {
            get
            {
                return this.patientGender;
            }
            set
            {
                this.patientGender = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientSnum
        {
            get
            {
                return this.patientSnum;
            }
            set
            {
                this.patientSnum = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientLocationId
        {
            get
            {
                return this.patientLocationId;
            }
            set
            {
                this.patientLocationId = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientICN
        {
            get
            {
                return this.patientICN;
            }
            set
            {
                this.patientICN = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientDFN
        {
            get
            {
                return this.patientDFN;
            }
            set
            {
                this.patientDFN = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string STA6N
        {
            get
            {
                return this.sTA6N;
            }
            set
            {
                this.sTA6N = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientAdmitTimeStamp
        {
            get
            {
                return this.patientAdmitTimeStamp;
            }
            set
            {
                this.patientAdmitTimeStamp = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string InstitutionName
        {
            get
            {
                return this.institutionName;
            }
            set
            {
                this.institutionName = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        // Demographics
        public string PatientAge
        {
            get
            {
                return this.patientAge;
            }
            set
            {
                this.patientAge = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientCity
        {
            get
            {
                return this.patientCity;
            }
            set
            {
                this.patientCity = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientState
        {
            get
            {
                return this.patientState;
            }
            set
            {
                this.patientState = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientMaritalStatus
        {
            get
            {
                return this.patientMaritalStatus;
            }
            set
            {
                this.patientMaritalStatus = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientReligion
        {
            get
            {
                return this.patientReligion;
            }
            set
            {
                this.patientReligion = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public int PatientRegion
        {
            get
            {
                return this.patientRegion;
            }
            set
            {
                this.patientRegion = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientRace
        {
            get
            {
                return this.patientRace;
            }
            set
            {
                this.patientRace = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string PatientEthnicity
        {
            get
            {
                return this.patientEthnicity;
            }
            set
            {
                this.patientEthnicity = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        //public string PatientPCP { get; set; }
        public int CprsSentTBIEvaluationNoteId
        {
            get
            {
                return this.cprsSentTBIEvaluationNoteId;
            }
            set
            {
                this.cprsSentTBIEvaluationNoteId = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public int CprsSentTBIFollowUpNoteId
        {
            get
            {
                return this.cprsSentTBIFollowUpNoteId;
            }
            set
            {
                this.cprsSentTBIFollowUpNoteId = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public NoteType SelectedNoteType
        {
            get
            {
                return this.selectedNoteType;
            }
            set
            {
                this.selectedNoteType = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string NoteText
        {
            get
            {
                return this.noteText;
            }
            set
            {
                this.noteText = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        //public InstrumentType SelectedInstrumentType { get; set; }

        public string SelectedNoteTitleId
        {
            get
            {
                return this.selectedNoteTitleId;
            }
            set
            {
                this.selectedNoteTitleId = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string SelectedConsultId
        {
            get
            {
                return this.selectedConsultId;
            }
            set
            {
                this.selectedConsultId = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string SelectedVisitId
        {
            get
            {
                return this.selectedVisitId;
            }
            set
            {
                this.selectedVisitId = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string SelectedHospitalAdmissionId
        {
            get
            {
                return this.selectedHospitalAdmissionId;
            }
            set
            {
                this.selectedHospitalAdmissionId = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string SelectedLocationID
        {
            get
            {
                return this.selectedLocationID;
            }
            set
            {
                this.selectedLocationID = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string SelectedNewVisitId
        {
            get
            {
                return this.selectedNewVisitId;
            }
            set
            {
                this.selectedNewVisitId = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string SelectedCosignerID
        {
            get
            {
                return this.selectedCosignerID;
            }
            set
            {
                this.selectedCosignerID = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public bool IsHistorical
        {
            get
            {
                return this.isHistorical;
            }
            set
            {
                this.isHistorical = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        //public List<InstrumentType> Instruments;
        public string StationNumber
        {
            get
            {
                return this.stationNumber;
            }
            set
            {
                this.stationNumber = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string ProviderDFN
        {
            get
            {
                return this.providerDFN;
            }
            set
            {
                this.providerDFN = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public ViaServices.ViaPerson VIAServiceCprsLaunch
        {
            get
            {
                return this.vIAServiceCprsLaunch;
            }
            set
            {
                this.vIAServiceCprsLaunch = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string LoginSiteCode
        {
            get
            {
                return this.loginSiteCode;
            }
            set
            {
                this.loginSiteCode = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string TokenizedDUZ
        {
            get
            {
                return this.tokenizedDUZ;
            }
            set
            {
                this.tokenizedDUZ = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        public string ProviderName
        {
            get
            {
                return this.providerName;
            }
            set
            {
                this.providerName = value;
                HttpContext.Current.Session["CprsSession"] = this;
            }
        }

        #endregion

        public void Refresh()
        {
            HttpContext.Current.Session["CprsSession"] = this;
        }
    }
}